<?php

namespace Daylight\Core\Livewire\Store\Users;

use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Password;
use Illuminate\View\View;
use Livewire\Component;

class UserActions extends Component
{
    public User $user;

    public function impersonate()
    {
        Auth::user()->impersonate($this->user);

        return redirect()->route($this->user->locale.'_page');
    }

    public function sendVerificationEmail()
    {
        $this->user->sendEmailVerificationNotification();

        return redirect(
            route('daylight.store.users.show', $this->user)
        )->with('success', __('Verification email sent'));
    }

    public function disableMfa()
    {
        $this->user->update([
            'mfa_secret' => null,
            'mfa_recovery_code' => null,
            'mfa_verified_at' => null,
        ]);

        return redirect(
            route('daylight.store.users.show', $this->user)
        )->with('success', __('MFA disabled'));
    }

    public function sendPasswordReset()
    {
        $status = Password::broker()->sendResetLink(['email' => $this->user->email]);

        if ($status === Password::RESET_LINK_SENT) {
            return redirect(
                route('daylight.store.users.show', $this->user)
            )->with('success', __('Password reset email sent'));
        }

        return redirect(route('daylight.store.users.show', $this->user));
    }

    public function render(): View
    {
        return view('daylight::livewire.store.users.user-actions');
    }
}
