<?php

namespace Daylight\Core\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class CustomerGroup extends Model
{
    protected $guarded = [];

    public function customers(): BelongsToMany
    {
        return $this->belongsToMany(Customer::class)
            ->withTimestamps();
    }

    public function products(): BelongsToMany
    {
        return $this->belongsToMany(Product::class)
            ->withTimestamps();
    }

    public static function getDefault(): self
    {
        return self::where('default', true)->first();
    }
}
