<?php

namespace Daylight\Core\Models;

use Daylight\Core\Models\Enums\AddressType;
use Daylight\Core\Models\Enums\CustomerType;
use Daylight\Core\Services\Countries;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class OrderAddress extends Model
{
    protected $guarded = [];

    protected $casts = [
        'type' => AddressType::class,
    ];

    public function order(): BelongsTo
    {
        return $this->belongsTo(Order::class);
    }

    public function country(): BelongsTo
    {
        return $this->belongsTo(Country::class);
    }

    public function hasExemptedVat(): bool
    {
        if ($this->order->customer->type === CustomerType::PERSONAL) {
            return false;
        }

        return $this->vat_number && $this->vat_number_verified_at && $this->country_id !== Countries::defaultCountry()->id;
    }
}
