<?php

namespace Daylight\Core\Modules\MediaLibrary\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreDirectoryRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->check() && auth()->user()->can('create:media');
    }

    public function rules(): array
    {
        return [
            'parent_id' => ['nullable', 'exists:directories,id'],
            'name' => ['required', 'string', 'max:255'],
        ];
    }
}
