<?php

namespace Daylight\Core\Modules\MediaLibrary;

use Daylight\Core\Modules\Admin\Entities\Page;
use Daylight\Core\Modules\Admin\Registries\NavigationRegistry;
use Illuminate\Support\ServiceProvider;

class MediaLibraryServiceProvider extends ServiceProvider
{
    public function register(): void {}

    public function boot(): void
    {
        app(NavigationRegistry::class)->register([
            Page::create()
                ->setOrder(100)
                ->setKey('media-library')
                ->setLabel('Media Library')
                ->setPermission('view:administration')
                ->setIcon('o-photo')
                ->setRoute('daylight.media.index'),
        ]);
    }
}
