import {defineConfig} from 'vite';
import vue from '@vitejs/plugin-vue';
import laravel from 'laravel-vite-plugin';

export default defineConfig({
    publicDir: false,
    resolve: {
        alias: {
            vue: 'vue/dist/vue.esm-bundler.js',
        },
    },
    plugins: [
        vue(),
        laravel({
            input: [
                'resources/assets/js/app.js',
                'resources/assets/css/app.scss',
            ],
            publicDirectory: 'dist',
            refresh: true,
        }),
    ]
});