<x-daylight::dropdown :name="__('Actions')">
    @if(is_null($user->email_verified_at))
        <x-daylight::dropdown-item wire:click.prevent="sendVerificationEmail">
            {{ __('Send verification mail') }}
        </x-daylight::dropdown-item>
    @endif

    <x-daylight::dropdown-item wire:click.prevent="sendPasswordReset">
        {{ __('Send reset password mail') }}
    </x-daylight::dropdown-item>

    @if($user->mfa_secret)
        <x-daylight::dropdown-item wire:click.prevent="disableMfa">
            {{ __('Disable MFA') }}
        </x-daylight::dropdown-item>
    @endif

    @can('impersonate:users')
        <x-daylight::dropdown-divider />

        <x-daylight::dropdown-item wire:click.prevent="impersonate">
            {{ __('Impersonate') }}
        </x-daylight::dropdown-item>
    @endcan
</x-daylight::dropdown>
