<x-daylight::tables.table>
    <x-slot:heading>
        <div>
            @foreach($this->getFilters() as $filter)
                <a href="{{ $filter['url'] }}" class="{{ $filter['active'] ? 'bg-gray-100 text-sky-600' : 'text-gray-600' }} inline-flex px-4 py-2 focus:outline-none font-semibold text-sm cursor-pointer rounded border-1 mb-4 border-blue-500">
                    {{ $filter['name'] }} ({{ number_format($filter['count'], 0, ',', '.') }})
                </a>
            @endforeach
        </div>
    </x-slot:heading>

    <x-slot:columns>
        <th class="p-3 text-left text-sm font-semibold text-gray-900" width="100">
            {{ __('Image') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900" width="200">
            {{ __('SKU') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900" >
            {{ __('Name') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900" >
            {{ __('Base price') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900" >
            {{ __('Status') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900" >
            {{ __('Configuration') }}
        </th>
    </x-slot:columns>

    @foreach ($this->rows as $row)
        <x-daylight::tables.row wire:key="{{ $row->id }}" :$row>
            <x-daylight::tables.column>
                <a href="{{ route('daylight.store.variants.edit', $row) }}">
                    @if($row->getFirstMedia())
                        <img src="{{ $row->getFirstMedia()->getUrl('square-small') }}" alt="{{ $row->name }}" class="h-12 w-12 object-cover rounded-md">
                    @endif
                </a>
            </x-daylight::tables.column>

            <x-daylight::tables.column>
                <a href="{{ route('daylight.store.variants.edit', $row) }}">
                    {{ $row->sku }}
                </a>
            </x-daylight::tables.column>

            <x-daylight::tables.column>
                {{ $row->title }}
            </x-daylight::tables.column>

            <x-daylight::tables.column>
                {{ formatPrice($row->basePrices->first()->price) }}
            </x-daylight::tables.column>

            <x-daylight::tables.column>
                @if($row->purchasable && $row->product_id)
                    <span class="text-green-600">{{ __('Active') }}</span>
                @elseif($row->purchasable && !$row->product_id)
                    <span class="text-yellow-600">{{ __('Not assigned') }}</span>
                @elseif(!$row->purchasable)
                    <span class="text-red-600">{{ __('Not purchasable') }}</span>
                @endif
            </x-daylight::tables.column>

            <x-daylight::tables.column>
                {{ $row->variationName ?? __('Unassigned') }}
            </x-daylight::tables.column>

            <x-slot:actions>
                <a href="{{ route('daylight.store.variants.edit', $row) }}" class="py-0.5 pl-2 pr-1 inline-flex font-medium items-center gap-1 text-sm">
                    {{ __('Edit') }}
                </a>
            </x-slot:actions>
        </x-daylight::tables.row>
    @endforeach
</x-daylight::tables.table>
