@extends('daylight::layouts.app')

@section('title', __('Edit country'))

@section('content')
    <x-daylight::page-header :title="__('Create country')" />

    <x-daylight::session-messages/>

    <form method="post" action="{{ route('daylight.settings.countries.store') }}">
        @csrf

        <x-daylight::input.group
            :label="__('Code')"
            :error="$errors->first('code')"
            for="code"
        >
            <x-daylight::input.select name="code" id="code">
                @foreach($countries as $key => $countryName)
                    <option value="{{ $key }}" @if($key == old('country')) selected @endif>
                        {{ $countryName }} ({{ $key }})
                    </option>
                @endforeach
            </x-daylight::input.select>
        </x-daylight::input.group>


        <x-daylight::input.group
            :label="__('Default')"
            :error="$errors->first('default')"
            for="code"
        >
            <div x-data="{ selected: {{ old('default', 0) ? '1' : '0' }}}">
                <div class="flex items-center">
                    <button :class="{ 'bg-sky-600': selected, 'bg-gray-200': !selected }" @click.prevent="selected = (selected === 0 ? 1 : 0)" type="button" class="relative inline-flex h-6 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent bg-gray-200 transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-indigo-600 focus:ring-offset-2" role="switch" aria-checked="false" aria-labelledby="annual-billing-label">
                        <span :class="{ 'translate-x-5': selected, 'translate-x-0': !selected }" aria-hidden="true" class="pointer-events-none inline-block h-5 w-5 translate-x-0 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out"></span>
                    </button>
                    <span class="ml-3 text-sm font-medium text-gray-900" id="annual-billing-label">{{ __('Default country') }}</span>
                </div>

                <input type="hidden" name="default" x-model="selected">
            </div>
        </x-daylight::input.group>

        <hr>

        <h3 class="font-medium text-lg text-gray-900 mt-6 mb-2">{{ __('Tax rates') }}</h3>

        @foreach($taxClasses as $taxClass)
            <x-daylight::input.group
                :label="$taxClass['taxClass']->name"
                :error="$errors->first('tax_classes.' . $taxClass['taxClass']->id)"
                for=""
            >
                <div class="grid grid-cols-3 gap-4">
                    <div>
                        <label class="text-xs text-gray-500 mb-1.5">{{ __('Name') }}</label>
                        <x-daylight::input.text
                            name="taxRates[{{ $taxClass['taxClass']->id }}][name]"
                            value="{{ old('taxRates.' . $taxClass['taxClass']->id . '.name', 'VAT') }}"
                        />
                        @error('taxRates.' . $taxClass['taxClass']->id . '.name')
                        <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="text-xs text-gray-500 mb-1.5">{{ __('Rate %') }}</label>
                        <x-daylight::input.text
                            name="taxRates[{{ $taxClass['taxClass']->id }}][rate]"
                            value="{{ old('taxRates.' . $taxClass['taxClass']->id . '.rate') }}"
                        />
                        @error('taxRates.' . $taxClass['taxClass']->id . '.rate')
                        <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </x-daylight::input.group>
        @endforeach

        <div class="mt-6 flex items-center justify-end gap-x-3">
            <x-daylight::buttons.secondary href="{{ route('daylight.settings.countries.index') }}" element="a">
                {{ __('Cancel') }}
            </x-daylight::buttons.secondary>

            <x-daylight::buttons.primary type="submit">
                {{ __('Save') }}
            </x-daylight::buttons.primary>
        </div>
    </form>
@endsection
