@extends('daylight::layouts.app')

@section('title', __('Settings'))

@section('content')
    <x-daylight::page-header :title="__('General')" />

    <x-daylight::session-messages />

    <form method="post" action="{{ route('daylight.settings.general.update') }}">
        @csrf
        @method('PUT')

        <x-daylight::input.group
                :label="__('Front page')"
                :error="$errors->first('frontPage')"
                for="frontPage"
        >
            <x-daylight::input.select name="frontPage" id="frontPage" :disabled="!auth()->user()->can('update:settings')">
                @foreach($pages as $page)
                    <option value="{{ $page->id }}" @if($page->id == old('frontPage', $settings->frontPage)) selected @endif>
                        {{ $page->translations->first()->name }}
                    </option>
                @endforeach
            </x-daylight::input.select>
        </x-daylight::input.group>

        <h3 class="font-medium text-lg text-gray-900 mt-6 mb-2">{{ __('Company') }}</h3>

        @php
            $fields = [
                'name' => __('Name'),
                'addressLine1' => __('Address line 1'),
                'addressLine2' => __('Address line 2'),
                'postalCode' => __('Postal code'),
                'city' => __('City'),
                'country' => __('Country'),
                'email' => __('Email'),
                'phoneNumber' => __('Phone number')
            ];
        @endphp

        @foreach($fields as $key => $field)
            <x-daylight::input.group
                :label="$field"
                :error="$errors->first($key)"
                for="{{ $key }}"
            >
                @if($key === 'country')
                    <x-daylight::input.select name="country" id="country" :disabled="!auth()->user()->can('update:settings')">
                        @foreach($countries as $key => $country)
                            <option value="{{ $key }}" @if($key == old('country', $settings->country)) selected @endif>
                                {{ $country }}
                            </option>
                        @endforeach
                    </x-daylight::input.select>
                @else
                    <x-daylight::input.text :name="$key" :id="$key" value="{{ old($key, $settings->$key) }}" :disabled="!auth()->user()->can('update:settings')"/>
                @endif
            </x-daylight::input.group>
        @endforeach

        <hr>

        <h3 class="font-medium text-lg text-gray-900 mt-6 mb-2">{{ __('Social media') }}</h3>

        @php
            $fields = [
                'facebookUrl' => __('Facebook URL'),
                'instagramUrl' => __('Instagram URL'),
                'youtubeUrl' => __('YouTube URL'),
                'linkedinUrl' => __('LinkedIn URL'),
            ];
        @endphp

        @foreach($fields as $key => $field)
            <x-daylight::input.group
                :label="$field"
                :error="$errors->first($key)"
                for="{{ $key }}"
            >
                <x-daylight::input.text :name="$key" :id="$key" value="{{ old($key, $settings->$key) }}" :disabled="!auth()->user()->can('update:settings')"/>
            </x-daylight::input.group>
        @endforeach

        @can('update:settings')
            <div class="mt-6 flex items-center justify-end gap-x-3">
                <x-daylight::buttons.primary type="submit">
                    {{ __('Save') }}
                </x-daylight::buttons.primary>
            </div>
        @endcan
    </form>
@endsection
