@extends('daylight::layouts.app')

@section('title', __('Create brand'))

@section('content')
    <x-daylight::page-header :title="__('Create brand')" />

    <x-daylight::session-messages/>

    <form method="post" action="{{ route('daylight.store.brands.store') }}">
        @csrf

        <x-daylight::input.group
            :label="__('Name')"
            :error="$errors->first('name')"
            for="code"
        >
            <x-daylight::input.text
                name="name"
                id="name"
                value="{{ old('name') }}"
            />
        </x-daylight::input.group>

        <x-daylight::input.group
            :label="__('Color')"
            :error="$errors->first('color')"
            for="code"
        >
            <x-daylight::input.text
                name="color"
                id="color"
                value="{{ old('color') }}"
                placeholder="#000000"
            />
        </x-daylight::input.group>
        
        <div class="mt-6 flex items-center justify-end gap-x-3">
            <x-daylight::buttons.secondary href="{{ route('daylight.store.brands.index') }}" element="a">
                {{ __('Cancel') }}
            </x-daylight::buttons.secondary>

            <x-daylight::buttons.primary type="submit">
                {{ __('Save') }}
            </x-daylight::buttons.primary>
        </div>
    </form>
@endsection
