@extends('daylight::layouts.app')

@section('title', __('Edit customer group'))

@section('content')
    <div x-data="{ showConfirmDeleteModal: false }">
        <x-daylight::page-header :title="__('Edit :page', ['page' => $customerGroup->name])">
            @can('update:customer-groups')
                <x-daylight::buttons.danger @click.prevent="showConfirmDeleteModal = true">
                    {{ __('Delete customer group') }}
                </x-daylight::buttons.danger>
            @endif
        </x-daylight::page-header>

        <x-daylight::session-messages/>

        <form method="post" action="{{ route('daylight.store.customer-groups.update', $customerGroup) }}">
            @csrf
            @method('PUT')

            <x-daylight::input.group
                :label="__('Name')"
                :error="$errors->first('name')"
                for="code"
            >
                <x-daylight::input.text
                    name="name"
                    id="name"
                    value="{{ old('name', $customerGroup->name) }}"
                    :disabled="!auth()->user()->can('update:customer-groups')"
                />
            </x-daylight::input.group>

            <x-daylight::input.group
                :label="__('Default')"
                :error="$errors->first('default')"
                for="default"
            >
                <div x-data="{ selected: {{ old('default', $customerGroup->default) ? '1' : '0' }}}">
                    <div class="flex items-center mt-1">
                        <button :class="{ 'bg-sky-600': selected, 'bg-gray-200': !selected }" @click.prevent="selected = (selected === 0 ? 1 : 0)" type="button" class="relative inline-flex h-6 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent bg-gray-200 transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-indigo-600 focus:ring-offset-2" role="switch" aria-checked="false" aria-labelledby="annual-billing-label">
                            <span :class="{ 'translate-x-5': selected, 'translate-x-0': !selected }" aria-hidden="true" class="pointer-events-none inline-block h-5 w-5 translate-x-0 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out"></span>
                        </button>
                        <span class="ml-3 text-sm font-medium text-gray-900" id="annual-billing-label">{{ __('Default') }}</span>
                    </div>

                    <input type="hidden" name="default" x-model="selected">
                </div>
            </x-daylight::input.group>

            @can('update:customer-groups')
                <div class="mt-6 flex items-center justify-end gap-x-3">
                    <x-daylight::buttons.secondary href="{{ route('daylight.store.customer-groups.index') }}" element="a">
                        {{ __('Cancel') }}
                    </x-daylight::buttons.secondary>

                    <x-daylight::buttons.primary type="submit">
                        {{ __('Save') }}
                    </x-daylight::buttons.primary>
                </div>
            @endcan
        </form>

        <x-daylight::modal.confirm-delete-modal>
            <x-slot name="content">
                <h3 class="text-base font-semibold leading-6 text-gray-900" id="modal-title">{{ __('Delete :object', ['object' => __('customer group')]) }}</h3>
                <div class="mt-2">
                    <p class="text-sm text-gray-500">
                        {{ __('Are you sure you want to delete this :object? This action cannot be undone.', ['object' => __('customer group')]) }}
                    </p>
                </div>
            </x-slot>

            <x-slot name="footer">
                <form method="post" action="{{ route('daylight.store.customer-groups.destroy', $customerGroup) }}">
                    @csrf
                    @method('DELETE')

                    <button type="button" class="mt-3 inline-flex w-full justify-center rounded-md bg-white px-3 py-2 text-sm font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-100 sm:mt-0 sm:w-auto" @click.prevent="showConfirmDeleteModal = false">
                        {{ __('Cancel') }}
                    </button>

                    <button type="submit" class="inline-flex w-full justify-center rounded-md bg-red-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-500 sm:ml-2 sm:w-auto">
                        {{ __('Delete') }}
                    </button>
                </form>
            </x-slot>
        </x-daylight::modal.confirm-delete-modal>
    </div>
@endsection
