@extends('daylight::layouts.app')

@section('title', $customer->name)

@section('content')
    <x-daylight::page-header :title="$customer->name">
        @can('update:customers')
            <x-daylight::buttons.primary href="{{ route('daylight.store.customers.edit', $customer) }}" element="a">
                {{ __('Edit') }}
            </x-daylight::buttons.primary>
        @endcan
    </x-daylight::page-header>

    <x-daylight::session-messages/>


    <x-daylight::input.group :label="__('Customer type')">
        <p class="block text-sm leading-6 text-gray-700 sm:pt-1.5">{{ $customer->type->label() }}</p>
    </x-daylight::input.group>
    <x-daylight::input.group :label="__('Entity name')">
        <p class="block text-sm leading-6 text-gray-700 sm:pt-1.5">{{ $customer->name }}</p>
    </x-daylight::input.group>

    <x-daylight::input.group :label="__('Default billing address')">
        <div class="block text-sm leading-6 text-gray-700 sm:pt-1.5">
            @if($customer->defaultBillingAddress)
                <x-daylight::address :address="$customer->defaultBillingAddress"/>
            @else
                <p class="block text-sm leading-6 text-gray-700">{{ __('No default billing address selected.') }}</p>
            @endif
        </div>
    </x-daylight::input.group>

    <x-daylight::input.group :label="__('Other addresses')">
        <div class="grid grid-cols-4 gap-4">
            @forelse($customer->addresses as $address)
                <div class="border p-4 block text-sm leading-6 text-gray-700">
                    <x-daylight::address :address="$address"/>
                </div>
            @empty
                <p class="block text-sm leading-6 text-gray-700 pt-1.5">{{ __('No addresses found for this customer.') }}</p>
            @endforelse
        </div>
    </x-daylight::input.group>

    <div class="my-6">
        <h3 class="text-base font-semibold leading-7 text-gray-900 mb-6">{{ __('Users associated with this customer') }}</h3>

        @if($customer->users_count === 0)
            <p class="block text-sm leading-6 text-gray-700">{{ __('No users associated with this customer.') }}</p>
        @else
            <livewire:daylight::customer-user-table :customer="$customer"/>
        @endif
    </div>

    <div class="my-6">
        <h3 class="text-base font-semibold leading-7 text-gray-900 mb-6">{{ __('Orders for this customer') }}</h3>
        @if($customer->orders_count === 0)
            <p class="block text-sm leading-6 text-gray-700">{{ __('No orders associated with this customer.') }}</p>
        @else
            <livewire:daylight::customer-order-table :customer="$customer"/>
        @endif
    </div>
@endsection
