<?php

namespace Daylight\Core\Livewire\Store;

use Daylight\Core\Livewire\Tables\BaseTable;
use Daylight\Core\Livewire\Tables\Concerns\WithSearch;
use Daylight\Core\Models\Attribute;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\View\View;

class AttributeTable extends BaseTable
{
    use WithSearch;

    protected function getBaseQuery(): Builder
    {
        return Attribute::query();
    }

    protected function applySearch(Builder $query, ?string $searchQuery): Builder
    {
        return $query->when($searchQuery, function ($query, $searchQuery) {
            $query->where('name', 'like', "%{$searchQuery}%");
        });
    }

    public function render(): View
    {
        return view('daylight::livewire.store.attribute-table');
    }
}
