<?php

namespace Daylight\Core\Models;

use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class OrderItem extends Model
{
    protected $guarded = [];

    protected $casts = [
        'tax_breakdown' => 'json',
    ];

    public function order(): BelongsTo
    {
        return $this->belongsTo(Order::class);
    }

    public function variant(): BelongsTo
    {
        return $this->belongsTo(Variant::class);
    }

    public function deliveryAddress(): BelongsTo
    {
        return $this->belongsTo(Address::class, 'delivery_address_id');
    }

    public function price(): Attribute
    {
        return Attribute::make(
            get: fn (string $value) => $value / 100,
        );
    }

    public function getArticleNumber(): string
    {
        return $this->variant->sku;
    }

    public function getNumber(): ?int
    {
        return $this->imdex_id;
    }

    public function getQuantity(): int
    {
        return $this->quantity;
    }

    public function getPrice(): float
    {
        return $this->price;
    }

    public function getDeliveryAddressNumber(): int
    {
        return $this->deliveryAddress->imdex_id;
    }
}
