<?php

namespace Daylight\Core\Models\Shipping;

use Daylight\Core\Models\Country;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;

class ShippingZone extends Model
{
    protected $guarded = [];

    public function shippingClasses()
    {
        return $this->belongsToMany(ShippingClass::class, ShippingZoneRule::class);
    }

    public function shippingZoneRules(): HasMany
    {
        return $this->hasMany(ShippingZoneRule::class);
    }

    public function countries(): BelongsToMany
    {
        return $this->belongsToMany(Country::class);
    }
}
