<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('attributes', function (Blueprint $table) {
            $table->index('filterable', 'attributes_filterable_index');
        });

        Schema::table('attribute_translations', function (Blueprint $table) {
            $table->index(['attribute_id', 'locale'], 'attribute_translations_attribute_id_locale_index');
        });

        if (Schema::hasColumn('attributes', 'key')) {
            Schema::table('attributes', function (Blueprint $table) {
                $table->index('key', 'attributes_key_index');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('attributes', function (Blueprint $table) {
            $table->dropIndex('attributes_filterable_index');

            if (Schema::hasColumn('attributes', 'key')) {
                $table->dropIndex('attributes_key_index');
            }
        });

        Schema::table('attribute_translations', function (Blueprint $table) {
            $table->dropIndex('attribute_translations_attribute_id_locale_index');
        });
    }
};
