#!/bin/bash

set -e

VERSION=$1

if [ -z "$VERSION" ]; then
  echo "❌ Usage: ./release.sh v1.0.0"
  exit 1
fi

sed -i '' "s/const CURRENT_VERSION = 'v[0-9]*\.[0-9]*\.[0-9]*';/const CURRENT_VERSION = '$VERSION';/" src/DaylightServiceProvider.php

echo "✅ Building assets..."
npm ci
npm run build

echo "✅ Committing built assets..."
git add . -A
git commit -m "Build assets for $VERSION"
git status

echo "✅ Tagging release: $VERSION"
git tag $VERSION

echo "✅ Pushing tag and commit..."
git push origin main
git push origin $VERSION

echo "✅ Pushing release"
git push --tags

echo "🎉 Release $VERSION created with built assets included."