<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('variants', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_id')->nullable()->constrained()->nullOnDelete();
            $table->string('sku')->nullable();
            $table->integer('stock')->default(0);
            $table->integer('purchasable')->default(1);
            $table->integer('order')->default(0)->nullable();
            $table->string('video_url')->nullable();
            $table->string('tax_class')->default('standard');
            $table->integer('weight')->nullable()->default(0);
            $table->timestamps();
            $table->softDeletes();

            $table->index('sku');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('variants');
    }
};
