<div x-data="{ uploadingFiles: [] }" 
     x-init="window.addEventListener('upload-progress-update', (e) => { uploadingFiles = e.detail.files || [] })">
    <div class="grid gap-4 lg:gap-6 mt-8 mb-6 {{ $selectable ? 'grid-cols-3 lg:grid-cols-6' : 'grid-cols-3 lg:grid-cols-10' }}">
        <!-- Uploading file placeholders -->
        <template x-for="(file, index) in uploadingFiles" :key="'uploading-' + index">
            <div class="relative group">
                <!-- Placeholder card -->
                <div class="relative rounded-lg overflow-hidden bg-gray-50 border border-gray-200 aspect-square flex items-center justify-center">
                    <!-- Loading states -->
                    <template x-if="file.status === 'pending'">
                        <div class="flex flex-col items-center">
                            <div class="w-10 h-10 bg-gray-100 rounded-full animate-pulse mb-2"></div>
                            <div class="h-2 bg-gray-100 rounded w-12 animate-pulse"></div>
                        </div>
                    </template>
                    
                    <template x-if="file.status === 'uploading'">
                        <div class="flex flex-col items-center">
                            <svg class="animate-spin h-10 w-10 text-gray-400 mb-2" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                            </svg>
                            <div class="text-xs text-gray-500 font-normal" x-text="file.progress + '%'"></div>
                        </div>
                    </template>
                    
                    <template x-if="file.status === 'success'">
                        <div class="absolute inset-0 bg-green-50 flex items-center justify-center">
                            <svg class="w-10 h-10 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                            </svg>
                        </div>
                    </template>
                    
                    <!-- Progress bar at bottom -->
                    <template x-if="file.status === 'uploading' || file.status === 'pending'">
                        <div class="absolute bottom-0 inset-x-0 h-0.5 bg-gray-100">
                            <div 
                                class="h-full transition-all duration-300 ease-out"
                                :class="file.status === 'uploading' ? 'bg-gray-400' : 'bg-gray-200'"
                                :style="'width: ' + (file.progress || 0) + '%'"
                            ></div>
                        </div>
                    </template>
                </div>
                
                <!-- File name -->
                <div class="mt-2 text-left">
                    <h3 class="text-gray-500 mb-0 text-sm truncate" x-text="file.name"></h3>
                    <p class="text-gray-400 mt-0 text-xs" x-text="(file.size / 1024).toFixed(0) + ' kb'"></p>
                </div>
            </div>
        </template>
        
        <!-- Actual files -->
        @foreach($this->files as $file)
            <livewire:daylight::media-file-item :file="$file" :selectable="$selectable" :single-file="$singleFile" :selected-items="$selectedItems" :key="'media-file-'.$file->id" />
        @endforeach
    </div>

    @if($this->files->total() > 0)
        <div class="mt-6">
            {{ $this->files->onEachSide(1)->links() }}
        </div>
    @endif
    
    @if($this->files->total() === 0)
        <x-daylight::media.empty-state />
    @endif
</div>


