<?php

namespace Daylight\Core;

use Daylight\Core\Console\InstallCommand;
use Daylight\Core\Console\PublishAssets;
use Daylight\Core\Console\PublishControllersCommand;
use Daylight\Core\Console\PublishModelsCommand;
use Daylight\Core\Console\ScoutFlushCommand;
use Daylight\Core\Console\ScoutImportCommand;
use Daylight\Core\Console\ScoutSyncSettingsCommands;
use Daylight\Core\Livewire\Content\PageTable;
use Daylight\Core\Livewire\Settings\CountryTable;
use Daylight\Core\Livewire\Settings\RoleTable;
use Daylight\Core\Livewire\Settings\ShippingClassTable;
use Daylight\Core\Livewire\Settings\ShippingZoneTable;
use Daylight\Core\Livewire\Settings\TaxClassTable;
use Daylight\Core\Livewire\Store\AttributeTable;
use Daylight\Core\Livewire\Store\BrandTable;
use Daylight\Core\Livewire\Store\CategoryTable;
use Daylight\Core\Livewire\Store\CustomerGroupTable;
use Daylight\Core\Livewire\Store\CustomerOrderTable;
use Daylight\Core\Livewire\Store\CustomerTable;
use Daylight\Core\Livewire\Store\CustomerUserTable;
use Daylight\Core\Livewire\Store\LabelTable;
use Daylight\Core\Livewire\Store\OrderTable;
use Daylight\Core\Livewire\Store\Products\AttributeSelector;
use Daylight\Core\Livewire\Store\Products\SkuInput;
use Daylight\Core\Livewire\Store\ProductTable;
use Daylight\Core\Livewire\Store\ProductVariantTable;
use Daylight\Core\Livewire\Store\UserOrderTable;
use Daylight\Core\Livewire\Store\Users\UserActions;
use Daylight\Core\Livewire\Store\UserTable;
use Daylight\Core\Livewire\Store\VariantTable;
use Daylight\Core\Modules\Admin\AdminServiceProvider;
use Daylight\Core\Modules\Cart\CartServiceProvider;
use Daylight\Core\Modules\MediaLibrary\MediaLibraryServiceProvider;
use Daylight\Core\Modules\MenuBuilder\MenuBuilderServiceProvider;
use Daylight\Core\Modules\PageBuilder\PageBuilderServiceProvider;
use Daylight\Core\Modules\Payment\PaymentServiceProvider;
use Daylight\Core\Modules\Pricing\PricingServiceProvider;
use Daylight\Core\Modules\Search\SearchServiceProvider;
use Daylight\Core\Providers\RouteServiceProvider;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\ServiceProvider;
use Livewire\Livewire;

class DaylightServiceProvider extends ServiceProvider
{
    const CURRENT_VERSION = '1.1.17';

    public function register(): void
    {
        $this->app->register(AdminServiceProvider::class);
        $this->app->register(RouteServiceProvider::class);
        $this->app->register(MediaLibraryServiceProvider::class);
        $this->app->register(PageBuilderServiceProvider::class);
        $this->app->register(MenuBuilderServiceProvider::class);
        $this->app->register(PricingServiceProvider::class);
        $this->app->register(CartServiceProvider::class);
        $this->app->register(SearchServiceProvider::class);
        $this->app->register(PaymentServiceProvider::class);

        $this->commands([
            PublishControllersCommand::class,
            PublishModelsCommand::class,
            PublishAssets::class,
            InstallCommand::class,
            ScoutImportCommand::class,
            ScoutFlushCommand::class,
            ScoutSyncSettingsCommands::class,
        ]);

        $this->loadTranslationsFrom(__DIR__ . '/../resources/lang', 'daylight');
        $this->loadMigrationsFrom(__DIR__ . '/../database/migrations');

        $this->mergeConfigFrom(__DIR__ . '/../config/daylight.php', 'daylight');
    }

    public function boot(): void
    {
        Livewire::component('daylight::country-table', CountryTable::class);
        Livewire::component('daylight::role-table', RoleTable::class);
        Livewire::component('daylight::shipping-class-table', ShippingClassTable::class);
        Livewire::component('daylight::shipping-zone-table', ShippingZoneTable::class);
        Livewire::component('daylight::page-table', PageTable::class);
        Livewire::component('daylight::tax-class-table', TaxClassTable::class);
        Livewire::component('daylight::attribute-table', AttributeTable::class);
        Livewire::component('daylight::brand-table', BrandTable::class);
        Livewire::component('daylight::category-table', CategoryTable::class);
        Livewire::component('daylight::customer-group-table', CustomerGroupTable::class);
        Livewire::component('daylight::customer-order-table', CustomerOrderTable::class);
        Livewire::component('daylight::customer-user-table', CustomerUserTable::class);
        Livewire::component('daylight::customer-table', CustomerTable::class);
        Livewire::component('daylight::label-table', LabelTable::class);
        Livewire::component('daylight::order-table', OrderTable::class);
        Livewire::component('daylight::product-table', ProductTable::class);
        Livewire::component('daylight::product-variant-table', ProductVariantTable::class);
        Livewire::component('daylight::user-order-table', UserOrderTable::class);
        Livewire::component('daylight::user-table', UserTable::class);
        Livewire::component('daylight::variant-table', VariantTable::class);
        Livewire::component('daylight::user-actions', UserActions::class);
        Livewire::component('daylight::attribute-selector', AttributeSelector::class);
        Livewire::component('daylight::sku-input', SkuInput::class);

        $this->loadViewsFrom(__DIR__ . '/../resources/views', 'daylight');

        Blade::anonymousComponentNamespace('daylight::components', 'daylight');
        Blade::componentNamespace('Daylight\\Core\\View\\Components', 'daylight');

        $this->publishes([
            __DIR__ . '/../resources/lang' => resource_path('lang/vendor/daylight'),
        ], 'daylight-translations');

        $this->publishes([
            __DIR__ . '/../database/migrations' => database_path('migrations'),
        ], 'daylight.migrations');

        $this->publishes([
            __DIR__ . '/../dist' => public_path('vendor/daylight/core'),
            __DIR__ . '/../resources/assets/js/slug.min.js' => public_path('vendor/daylight/core/slug.min.js'),
        ], 'daylight.assets');

        $this->publishes([
            __DIR__ . '/../config/daylight.php' => config_path('daylight.php'),
            __DIR__ . '/../config/multilingualism.php' => config_path('multilingualism.php'),
        ], 'daylight.config');
    }
}
