<?php

namespace Daylight\Core\Http\Requests\Store\Attributes;

use Illuminate\Foundation\Http\FormRequest;

class UpdateAttributeRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->check() && auth()->user()->can('update:attributes');
    }

    public function rules(): array
    {
        return [
            'parent_id' => ['nullable', 'exists:categories,id'],
            'key' => ['required', 'string', 'max:255', 'unique:attributes,key,' . $this->route('attribute')->id],
            'categories' => ['nullable', 'array'],
            'categories.*' => ['exists:categories,id'],
            'filterable' => ['required', 'boolean'],
            'visible' => ['required', 'boolean'],
            'translations' => ['required', 'array'],
            'translations.*.name' => ['required', 'string', 'max:255'],
            'values' => ['required', 'array'],
            'values.*.id' => ['nullable', 'exists:attribute_values,id'],
            'values.*.translations' => ['required', 'array'],
            'values.*.translations.*.name' => ['required', 'string', 'max:255'],
        ];
    }

    public function prepareForValidation(): void
    {
        $this->merge([
            'key' => strtoupper(str_replace(' ', '_', $this->key)),
        ]);
    }
}
