<?php

namespace Daylight\Core\Http\Requests\Store\CustomerGroups;

use Illuminate\Foundation\Http\FormRequest;

class UpdateCustomerGroupRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->check() && auth()->user()->can('update:customer-groups');
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:255'],
            'default' => ['required', 'integer', 'between:0,1'],
        ];
    }
}
