<?php

namespace Daylight\Core\Http\Requests\Store\Labels;

use Illuminate\Foundation\Http\FormRequest;

class UpdateLabelRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->check() && auth()->user()->can('update:labels');
    }

    public function rules(): array
    {
        return [
            'background' => ['required', 'string', 'max:255'],
            'text_color' => ['required', 'string', 'max:255'],
            'translations' => ['required', 'array'],
            'translations.*.name' => ['required', 'string', 'max:255'],
        ];
    }
}
