<?php

namespace Daylight\Core\Livewire\Tables\Concerns;

use Illuminate\Database\Eloquent\Builder;
use Livewire\Attributes\Url;

trait WithMultilingualism
{
    public bool $multilingualism = true;

    #[Url]
    public ?string $locale = null;

    abstract protected function applyMultilingualism(Builder $query, ?string $locale): Builder;
}
