<?php

namespace Daylight\Core\Modules\MediaLibrary\Livewire;

use Daylight\Core\Modules\MediaLibrary\Models\Directory;
use Illuminate\Support\Collection;
use Illuminate\View\View;
use Livewire\Attributes\Computed;
use Livewire\Component;

class DirectoryList extends Component
{
    public ?int $directoryId = null;

    public bool $selectable = false;

    #[Computed]
    public function directories(): Collection
    {
        if ($this->directoryId) {
            return Directory::query()
                ->withCount('children')
                ->whereParentId($this->directoryId)
                ->get();
        }

        return Directory::query()
            ->withCount('children')
            ->whereNull('parent_id')
            ->get();
    }

    public function open(int $id): void
    {
        $this->dispatch('change-current-directory', $id);
    }

    public function render(): View
    {
        return view('daylight::livewire.media.directory-list', [
            'directories' => $this->directories(),
        ]);
    }
}
