import slug from 'alpinejs-slug'
import { Livewire, Alpine } from '../../../vendor/livewire/livewire/dist/livewire.esm';
import { createApp } from 'vue'
import MediaLibrary from "./modules/MediaLibrary/MediaLibrary.vue";
import { createRouter, createWebHashHistory } from 'vue-router'
import MediaSelector from "./modules/MediaLibrary/MediaSelector.vue";
import MenuBuilder from "./modules/MenuBuilder/MenuBuilder.vue";
import PageBuilder from "./modules/PageBuilder/PageBuilder.vue";
import VariationBuilder from "./modules/VariationBuilder/VariationBuilder.vue";
import { createI18n, createVueI18nPlugin } from './utils/i18n';

import.meta.glob([
    '../images/**',
]);

Alpine.plugin(slug)
Livewire.start()

document.addEventListener('DOMContentLoaded', async () => {
    const i18n = await createI18n({
        locale: window.daylight?.locale,
        fallbackLocale: window.daylight?.fallbackLocale,
        url: window.daylight?.translationsUrl,
    });
    const i18nPlugin = createVueI18nPlugin(i18n);
    window.daylight = Object.assign({}, window.daylight, { __: i18n.__ });
    const appContainers = document.querySelectorAll('[data-vue-app]')

    appContainers.forEach(el => {
        const app = createApp({})
        app.use(i18nPlugin)

        app.use(createRouter({
            history: createWebHashHistory(),
            routes: [
                { path: '/', name: 'default', component: MediaLibrary },
            ],
        }));

        app.component('media-library', MediaLibrary)
        app.component('media-selector', MediaSelector)
        app.component('menu-builder', MenuBuilder)
        app.component('page-builder', PageBuilder)
        app.component('variation-builder', VariationBuilder)

        app.mount(el)
    });
})