<x-daylight::tables.table>
    <x-slot:columns>
        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            {{ __('daylight::general.name') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            Locales
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            Status
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            Created at
        </th>
    </x-slot:columns>

    @foreach ($this->rows as $row)
        <x-daylight::tables.row wire:key="{{ $row->id }}" :$row>
            <x-daylight::tables.column>
                @can('update:menus')
                    <a href="{{ route('daylight.content.menus.edit', ['menu' => $row, 'locale' => request()->get('locale', $locale)]) }}">{{ $row->name }}</a>
                @else
                    {{ $row->name }}
                @endif
                <p class="text-sm text-gray-400"></p>
            </x-daylight::tables.column>

            <x-daylight::tables.column>
                <div class="flex -space-x-1 overflow-hidden">
                    @foreach($row->translations as $translation)
                        <img src="{{ daylightAsset('resources/assets/images/flags/'.strtolower($translation->locale).'.svg') }}" alt="{{ $row->name }}" class="inline-block h-5 w-5 rounded-full ring-2 ring-white mr-2">
                    @endforeach
                </div>
            </x-daylight::tables.column>
            <x-daylight::tables.column>
                <div class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">
                    Active
                </div>
            </x-daylight::tables.column>
            <x-daylight::tables.column>{{ $row->created_at->isoFormat('LLL') }}</x-daylight::tables.column>

            <x-slot:actions>
                @can('update:menus')
                    <a href="{{ route('daylight.content.menus.edit', ['menu' => $row, 'locale' => request()->get('locale', $locale)]) }}"
                       class="py-0.5 pl-2 pr-1 inline-flex font-medium items-center gap-1 text-sm">
                        Edit
                    </a>
                @endif
            </x-slot:actions>
        </x-daylight::tables.row>
    @endforeach
</x-daylight::tables.table>
