@extends('daylight::layouts.app')

@section('title', __('daylight::settings.edit_shipping_class'))

@section('content')
    <div x-data="{ showConfirmDeleteModal: false }">
        <x-daylight::page-header :title="__('daylight::general.edit_page', ['page' => $shippingClass->name])">
            @can('update:advanced-settings')
                <x-daylight::buttons.danger @click.prevent="showConfirmDeleteModal = true">
                    {{ __('daylight::settings.delete_shipping_class') }}
                </x-daylight::buttons.danger>
            @endif
        </x-daylight::page-header>

        <x-daylight::session-messages/>

        <form method="post" action="{{ route('daylight.settings.shipping-classes.update', $shippingClass) }}">
            @csrf
            @method('PUT')

            <x-daylight::input.group
                :label="__('daylight::general.name')"
                :error="$errors->first('name')"
                for="code"
            >
                <x-daylight::input.text
                    name="name"
                    id="name"
                    value="{{ old('name', $shippingClass->name) }}"
                    :disabled="!auth()->user()->can('update:advanced-settings')"
                />
            </x-daylight::input.group>

            <x-daylight::input.group
                :label="__('daylight::general.default')"
                :error="$errors->first('default')"
                for=""
            >
                <div class="relative">
                    @if(!auth()->user()->can('update:advanced-settings'))
                        <div class="absolute inset-0 w-full h-full z-200"></div>
                    @endcan
                    <div x-data="{ selected: {{ old('default', $shippingClass->default) ? '1' : '0' }}}">
                        <div class="flex items-center mt-1">
                            <button :class="{ 'bg-sky-600': selected, 'bg-gray-200': !selected }"
                                    @click.prevent="selected = (selected === 0 ? 1 : 0)" type="button"
                                    class="relative inline-flex h-6 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent bg-gray-200 transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-indigo-600 focus:ring-offset-2"
                                    role="switch" aria-checked="false" aria-labelledby="annual-billing-label">
                            <span :class="{ 'translate-x-5': selected, 'translate-x-0': !selected }" aria-hidden="true"
                                  class="pointer-events-none inline-block h-5 w-5 translate-x-0 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out"></span>
                            </button>
                            <span class="ml-3 text-sm font-medium text-gray-900"
                                  id="annual-billing-label">{{ __('daylight::general.default') }}</span>
                        </div>

                        <input type="hidden" name="default" x-model="selected">
                    </div>
                </div>
            </x-daylight::input.group>

            <x-daylight::input.group
                :label="__('daylight::general.cumulative')"
                :error="$errors->first('cumulative')"
                for=""
            >
                <div class="relative">
                    @if(!auth()->user()->can('update:advanced-settings'))
                        <div class="absolute inset-0 w-full h-full z-200"></div>
                    @endcan
                    <div x-data="{ selected: {{ old('cumulative', $shippingClass->cumulative) ? '1' : '0' }}}">
                        <div class="flex items-center mt-1">
                            <button :class="{ 'bg-sky-600': selected, 'bg-gray-200': !selected }"
                                    @click.prevent="selected = (selected === 0 ? 1 : 0)" type="button"
                                    class="relative inline-flex h-6 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent bg-gray-200 transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-indigo-600 focus:ring-offset-2"
                                    role="switch" aria-checked="false" aria-labelledby="annual-billing-label">
                                <span :class="{ 'translate-x-5': selected, 'translate-x-0': !selected }" aria-hidden="true"
                                      class="pointer-events-none inline-block h-5 w-5 translate-x-0 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out"></span>
                            </button>
                            <span class="ml-3 text-sm font-medium text-gray-900"
                                  id="annual-billing-label">{{ __('daylight::general.cumulative') }}</span>
                        </div>

                        <input type="hidden" name="cumulative" x-model="selected">
                    </div>
                </div>
            </x-daylight::input.group>

            @can('update:advanced-settings')
                <div class="mt-6 flex items-center justify-end gap-x-3">
                    <x-daylight::buttons.secondary href="{{ route('daylight.settings.shipping-classes.index') }}" element="a">
                        {{ __('daylight::general.cancel') }}
                    </x-daylight::buttons.secondary>

                    <x-daylight::buttons.primary type="submit">
                        {{ __('daylight::general.save') }}
                    </x-daylight::buttons.primary>
                </div>
            @endcan
        </form>

        <x-daylight::modal.confirm-delete-modal>
            <x-slot name="content">
                <h3 class="text-base font-semibold leading-6 text-gray-900"
                    id="modal-title">{{ __('daylight::general.delete_object', ['object' => __('daylight::store.daylight::store.shipping_class')]) }}</h3>
                <div class="mt-2">
                    <p class="text-sm text-gray-500">
                        {{ __('daylight::general.delete_confirm', ['object' => __('daylight::store.daylight::store.shipping_class')]) }}
                    </p>
                </div>
            </x-slot>

            <x-slot name="footer">
                <form method="post" action="{{ route('daylight.settings.shipping-classes.destroy', $shippingClass) }}">
                    @csrf
                    @method('DELETE')

                    <button type="button"
                            class="mt-3 inline-flex w-full justify-center rounded-md bg-white px-3 py-2 text-sm font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-100 sm:mt-0 sm:w-auto"
                            @click.prevent="showConfirmDeleteModal = false">
                        {{ __('daylight::general.cancel') }}
                    </button>

                    <button type="submit"
                            class="inline-flex w-full justify-center rounded-md bg-red-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-500 sm:ml-2 sm:w-auto">
                        {{ __('daylight::general.delete') }}
                    </button>
                </form>
            </x-slot>
        </x-daylight::modal.confirm-delete-modal>
    </div>
@endsection
