<?php

namespace Daylight\Core\Http\Requests\Settings;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use PeterColes\Countries\CountriesFacade;

class UpdateGeneralSettingsRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->check() && auth()->user()->can('update:settings');
    }

    public function rules(): array
    {
        $countries = CountriesFacade::lookup(app()->getLocale())->keys();

        return [
            'frontPage' => ['required', 'integer', 'exists:pages,id'],
            'name' => ['required', 'string'],
            'addressLine1' => ['required', 'string'],
            'addressLine2' => ['nullable', 'string'],
            'postalCode' => ['required', 'string'],
            'city' => ['required', 'string'],
            'country' => ['required', 'string', Rule::in($countries)],
            'email' => ['required', 'email'],
            'phoneNumber' => ['required', 'string'],
            'facebookUrl' => ['nullable', 'url'],
            'instagramUrl' => ['nullable', 'url'],
            'youtubeUrl' => ['nullable', 'url'],
        ];
    }
}
