<x-daylight::tables.table>
    <x-slot:columns>
        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            {{ __('daylight::general.image') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            {{ __('daylight::general.sku') }}
        </th>

        @if($product->type === 'variable')
            <th class="p-3 text-left text-sm font-semibold text-gray-900">
                {{ __('Options') }}
            </th>
        @endif

        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            {{ __('daylight::general.price') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            {{ __('Stock') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            {{ __('Weight') }}
        </th>
    </x-slot:columns>

    @foreach ($this->rows as $row)
        <x-daylight::tables.row wire:key="{{ $row->id }}" :$row>
            <x-daylight::tables.column>
                <a href="{{ route('daylight.store.variants.edit', $row) }}">
                    @if($row->getFirstMedia('gallery'))
                        <img src="{{ $row->getFirstMedia('gallery')->getUrl('thumbnail') }}" alt="{{ $row->name }}" class="h-12 w-12 object-contain border rounded-md">
                    @endif
                </a>
            </x-daylight::tables.column>

            <x-daylight::tables.column>
                <a href="{{ route('daylight.store.variants.edit', $row) }}">
                    {{ $row->sku }}
                </a>
            </x-daylight::tables.column>

            @if($product->type === 'variable')
                <x-daylight::tables.column>
                    {{ $row->variationName ?? 'N/A' }}
                </x-daylight::tables.column>
            @endif

            <x-daylight::tables.column>
                {{ formatPrice($row->prices->firstWhere('customer_group_id', null)->price) }}
            </x-daylight::tables.column>

            <x-daylight::tables.column>
                {{ $row->stock ? 'In stock' : 'Out of stock' }}
            </x-daylight::tables.column>

            <x-daylight::tables.column>
                {{ formatNumber($row->weight) }}g
            </x-daylight::tables.column>

            <x-slot:actions>
                <a href="{{ route('daylight.store.variants.edit', $row) }}" class="py-0.5 pl-2 pr-1 inline-flex font-medium items-center gap-1 text-sm">
                    {{ __('daylight::general.edit') }}
                </a>
            </x-slot:actions>
        </x-daylight::tables.row>
    @endforeach
</x-daylight::tables.table>
