<?php

namespace Daylight\Core\Http\Controllers\Settings;

use Daylight\Core\Http\Controllers\Controller;
use Daylight\Core\Http\Requests\Settings\TaxClasses\StoreTaxClassRequest;
use Daylight\Core\Http\Requests\Settings\TaxClasses\UpdateTaxClassRequest;
use Daylight\Core\Models\TaxClass;
use Illuminate\Routing\Controllers\HasMiddleware;
use Illuminate\Routing\Controllers\Middleware;

class TaxClassController extends Controller implements HasMiddleware
{
    public static function middleware(): array
    {
        return [
            new Middleware('can:update:advanced-settings', only: ['create', 'store', 'update', 'destroy']),
            new Middleware('can:read:advanced-settings', only: ['index', 'show', 'edit']),
        ];
    }

    public function index()
    {
        return view('daylight::settings.tax-classes.index');
    }

    public function create()
    {
        return view('daylight::settings.tax-classes.create');
    }

    public function store(StoreTaxClassRequest $request)
    {
        $taxClass = (daylightModel('tax_class'))::create($request->validated());

        return redirect()->route('daylight.settings.tax-classes.edit', $taxClass)
            ->with('success', __('Tax class created'));
    }

    public function edit(TaxClass $taxClass)
    {
        return view('daylight::settings.tax-classes.edit', [
            'taxClass' => $taxClass,
        ]);
    }

    public function update(UpdateTaxClassRequest $request, TaxClass $taxClass)
    {
        $taxClass->update($request->validated());

        return redirect()->route('daylight.settings.tax-classes.index')
            ->with('success', __('Tax class updated'));
    }

    public function destroy(TaxClass $taxClass)
    {
        $taxClass->delete();

        return redirect()->route('daylight.settings.tax-classes.index')
            ->with('success', __('Tax class deleted'));
    }
}
