<?php

namespace Daylight\Core\Livewire\Store;

use App\Models\User;
use Daylight\Core\Livewire\Tables\BaseTable;
use Daylight\Core\Livewire\Tables\Concerns\WithSearch;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\View\View;

class UserTable extends BaseTable
{
    use WithSearch;

    protected function getBaseQuery(): Builder
    {
        return User::query()->latest();
    }

    protected function applySearch(Builder $query, ?string $searchQuery): Builder
    {
        return $query->when($searchQuery, function ($query, $searchQuery) {
            $query->where('name', 'like', "%{$searchQuery}%");
        });
    }

    public function render(): View
    {
        return view('daylight::livewire.store.user-table');
    }
}
