<?php

namespace Daylight\Core\Models;

use Daylight\Core\Modules\Multilingualism\Contracts\HasTranslations;
use Daylight\Core\Modules\Multilingualism\Models\Concerns\InteractsWithTranslations;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class AttributeValue extends Model implements HasTranslations
{
    use InteractsWithTranslations;

    protected $guarded = [];

    public function translatedFields(): array
    {
        return ['name'];
    }

    public function attribute(): BelongsTo
    {
        return $this->belongsTo(daylightModel('attribute'));
    }

    public function product(): BelongsToMany
    {
        return $this->belongsToMany(daylightModel('product'))->withTimestamps();
    }

    public function translations(): HasMany
    {
        return $this->hasMany(daylightModel('attribute_value_translation'));
    }

    public function defaultTranslation(): HasOne
    {
        return $this
            ->hasOne(daylightModel('attribute_value_translation'))
            ->where('locale', config('multilingualism.default_locale'));
    }
}
