@props([
    'currentDirectory' => null,
])

<div {{ $attributes->merge(['class' => 'fixed inset-0 z-500 flex items-center justify-center']) }} style="display: none;" x-cloak>
    <div class="fixed inset-0 bg-black/30" x-on:click="$dispatch('close')"></div>

    <div class="bg-white rounded-lg shadow-lg w-full max-w-md relative z-10 p-6">
        <h3 class="text-lg font-medium mb-4">{{ __('daylight::media.create_directory') }}</h3>

        <form class="space-y-4" wire:submit.prevent="createDirectory">
            <div>
                <label for="newDirectoryName" class="block text-sm font-medium text-gray-700">{{ __('daylight::media.directory_name') }}</label>
                <input id="newDirectoryName" type="text" wire:model.defer="newDirectoryName" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-sky-500 focus:ring-sky-500 sm:text-sm">
                @error('newDirectoryName')
                    <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <div class="flex items-center justify-end gap-3">
                <x-daylight::buttons.secondary x-on:click.prevent="$dispatch('close')">{{ __('daylight::general.cancel') }}</x-daylight::buttons.secondary>
                <x-daylight::buttons.primary type="submit">{{ __('daylight::general.create') }}</x-daylight::buttons.primary>
            </div>
        </form>
    </div>
</div>


