<x-daylight::tables.table>
    <x-slot:heading>
        <div>
            @foreach($this->getFilters() as $filter)
                <a href="{{ $filter['url'] }}" class="{{ $filter['active'] ? 'bg-gray-100 text-sky-600' : 'text-gray-600' }} inline-flex px-4 py-2 focus:outline-none font-semibold text-sm cursor-pointer rounded border-1 mb-4 border-blue-500">
                    {{ $filter['name'] }} ({{ number_format($filter['count'], 0, ',', '.') }})
                </a>
            @endforeach
        </div>
    </x-slot:heading>

    <x-slot:columns>
        <th class="p-3 text-left text-sm font-semibold text-gray-900" width="100">
            {{ __('daylight::general.image') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900" width="200">
            {{ __('daylight::general.sku') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900" >
            {{ __('daylight::general.name') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900" >
            {{ __('daylight::general.base_price') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900" >
            {{ __('daylight::general.stock') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900" >
            {{ __('daylight::general.status') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900" >
            {{ __('daylight::general.configuration') }}
        </th>
    </x-slot:columns>

    @foreach ($this->rows as $row)
        <x-daylight::tables.row wire:key="{{ $row->id }}" :$row>
            <x-daylight::tables.column>
                <a href="{{ route('daylight.store.variants.edit', $row) }}">
                    @if($row->getFirstMedia('gallery'))
                        <img src="{{ $row->getFirstMedia('gallery')->getUrl('thumbnail') }}" alt="{{ $row->name }}" class="h-12 w-12 object-cover rounded-md">
                    @endif
                </a>
            </x-daylight::tables.column>

            <x-daylight::tables.column>
                <a href="{{ route('daylight.store.variants.edit', $row) }}">
                    {{ $row->sku }}
                </a>
            </x-daylight::tables.column>

            <x-daylight::tables.column>
                {{ $row->name }}
            </x-daylight::tables.column>

            <x-daylight::tables.column>
                @if(!$row->basePrices->first())
                    <span class="text-red-600">{{ __('daylight::general.no_price_defined') }}</span>
                @else
                    {{ formatPrice($row->basePrices->first()->price) }}
                @endif
            </x-daylight::tables.column>

            <x-daylight::tables.column>
                <p>{{ $row->inStock() ? $row->stockStatus->getLabel() . ' ('.$row->stock.')' : $row->stockStatus->getLabel() }}</p>
                <p class="opacity-50">{{ $row->backorders ? __('daylight::general.backorders_enabled') : __('daylight::general.backorders_disabled') }}</p>
            </x-daylight::tables.column>

            <x-daylight::tables.column>
                @if($row->purchasable && $row->product_id)
                    <span class="text-green-600">{{ __('daylight::general.active') }}</span>
                @elseif($row->purchasable && !$row->product_id)
                    <span class="text-yellow-600">{{ __('daylight::general.not_assigned') }}</span>
                @elseif(!$row->purchasable)
                    <span class="text-red-600">{{ __('daylight::general.not_purchasable') }}</span>
                @endif
            </x-daylight::tables.column>

            <x-daylight::tables.column>
                {{ $row->variationName ?? __('daylight::general.unassigned') }}
            </x-daylight::tables.column>

            <x-slot:actions>
                <a href="{{ route('daylight.store.variants.edit', $row) }}" class="py-0.5 pl-2 pr-1 inline-flex font-medium items-center gap-1 text-sm">
                    {{ __('daylight::general.edit') }}
                </a>
            </x-slot:actions>
        </x-daylight::tables.row>
    @endforeach
</x-daylight::tables.table>
