@extends('daylight::layouts.app')

@section('title', __('daylight::settings.navigation'))

@section('content')
    <x-daylight::page-header :title="__('daylight::settings.navigation')"/>

    <x-daylight::session-messages />

    <form method="post" action="{{ route('daylight.settings.navigation.index') }}">
        @csrf
        @method('PUT')

        @foreach($menuLocations as $location)
            <x-daylight::input.group
                :label="$location->label"
                :error="$errors->first($location->key)"
                for="{{ $location->key }}"
            >
                <x-daylight::input.select :name="'menus[' . $location->key . ']'" :id="$location->key" :disabled="!auth()->user()->can('update:settings')">
                    @foreach($menus as $menu)
                        <option value="{{ $menu->id }}" @if($menu->id == old($location->key, $settings->menus[$location->key] ?? false)) selected @endif>
                            {{ $menu->name }}
                        </option>
                    @endforeach
                </x-daylight::input.select>
            </x-daylight::input.group>
        @endforeach

        @can('update:settings')
            <div class="mt-6 flex items-center justify-end gap-x-3">
                <x-daylight::buttons.primary type="submit">
                    {{ __('daylight::general.save') }}
                </x-daylight::buttons.primary>
            </div>
        @endcan
    </form>
@endsection
