@extends('daylight::layouts.app')

@section('title', __('daylight::general.edit_page', ['page' => $variant->sku]))

@section('content')
    <div x-data="{ showConfirmDeleteModal: false }">
        <x-daylight::page-header :title="__('daylight::general.edit_page', ['page' => $variant->sku . ' ' . $variant->title])">
            @can('delete:variants')
                <x-daylight::buttons.danger @click.prevent="showConfirmDeleteModal = true">
                    {{ __('Delete variant') }}
                </x-daylight::buttons.danger>
            @endif
        </x-daylight::page-header>

        <x-daylight::session-messages/>

        <form method="post" action="{{ route('daylight.store.variants.update', $variant) }}">
            @csrf
            @method('PUT')

            <div class="w-full">
                @if($variant->product_id)
                    <x-daylight::input.group
                        :label="__('Product')"
                        :error="$errors->first('product')"
                        for="product"
                    >
                        <a class="mt-1.5 flex text-blue-600 items-center text-sm"
                           href="{{ route('daylight.store.products.show', $variant->product) }}">
                            <svg class="w-4 h-4  mr-1.5" data-slot="icon" fill="none" stroke-width="1.5"
                                 stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"
                                 aria-hidden="true">
                                <path stroke-linecap="round" stroke-linejoin="round"
                                      d="M13.19 8.688a4.5 4.5 0 0 1 1.242 7.244l-4.5 4.5a4.5 4.5 0 0 1-6.364-6.364l1.757-1.757m13.35-.622 1.757-1.757a4.5 4.5 0 0 0-6.364-6.364l-4.5 4.5a4.5 4.5 0 0 0 1.242 7.244"></path>
                            </svg>

                            {{ $variant->product->name }}
                        </a>
                    </x-daylight::input.group>
                @endif
                <x-daylight::input.group
                    :label="__('Article number')"
                    :error="$errors->first('sku')"
                    for="sku"
                >
                    <x-daylight::input.text
                        id="sku"
                        value="{{ $variant->sku }}"
                        disabled
                    />
                </x-daylight::input.group>

                <x-daylight::input.group
                    :label="__('daylight::general.name')"
                    :error="$errors->first('name')"
                    for="title"
                >
                    <x-daylight::input.text
                        id="title"
                        value="{{ $variant->name }}"
                        disabled
                    />
                </x-daylight::input.group>


                <x-daylight::input.group :label="__('Gallery')" :error="$errors->first('gallery')" for="gallery">
                    <livewire:daylight::media-selector
                        name="gallery"
                        :initial-media="$variant->getMedia('gallery')"
                        :single-file="false"
                        display-type="gallery"
                    />
                </x-daylight::input.group>

                <x-daylight::input.group
                    :label="__('Video')"
                    :error="$errors->first('video')"
                    for="video"
                >
                    <x-daylight::input.text
                        id="video_url"
                        type="url"
                        name="video_url"
                        value="{{ $variant->video_url }}"
                        placeholder="https://"
                    />
                </x-daylight::input.group>

            </div>

            @can('update:variants')
                <div class="mt-6 flex items-center justify-end gap-x-3">
                    <x-daylight::buttons.secondary href="{{ route('daylight.store.variants.index') }}" element="a">
                        {{ __('daylight::general.cancel') }}
                    </x-daylight::buttons.secondary>

                    <x-daylight::buttons.primary type="submit">
                        {{ __('daylight::general.save') }}
                    </x-daylight::buttons.primary>
                </div>
            @endcan
        </form>

        <x-daylight::modal.confirm-delete-modal>
            <x-slot name="content">
                <h3 class="text-base font-semibold leading-6 text-gray-900"
                    id="modal-title">{{ __('daylight::general.delete_object', ['object' => __('daylight::store.variant')]) }}</h3>
                <div class="mt-2">
                    <p class="text-sm text-gray-500">
                        {{ __('daylight::general.delete_confirm', ['object' => __('daylight::store.product')]) }}
                    </p>
                </div>
            </x-slot>

            <x-slot name="footer">
                <form method="post" action="{{ route('daylight.store.variants.destroy', $variant) }}">
                    @csrf
                    @method('DELETE')

                    <button type="button"
                            class="mt-3 inline-flex w-full justify-center rounded-md bg-white px-3 py-2 text-sm font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-100 sm:mt-0 sm:w-auto"
                            @click.prevent="showConfirmDeleteModal = false">
                        {{ __('daylight::general.cancel') }}
                    </button>

                    <button type="submit"
                            class="inline-flex w-full justify-center rounded-md bg-red-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-500 sm:ml-2 sm:w-auto">
                        {{ __('daylight::general.delete') }}
                    </button>
                </form>
            </x-slot>
        </x-daylight::modal.confirm-delete-modal>
    </div>
@endsection
