<?php

namespace Daylight\Core\Modules\Search\Entities;

use Daylight\Core\Modules\Multilingualism\Translations;
use Daylight\Core\Modules\Search\Concerns\InteractsWithQueryString;
use Daylight\Core\Modules\Search\Contracts\Filter;

class ActiveFilter implements Filter
{
    use InteractsWithQueryString;

    public string $deleteUrl;

    public string $group;

    public string $name;

    public function __construct(SearchResult $searchResult, public string $key, public string $value)
    {
        $filters = $searchResult->request->getActiveFilters();
        $this->deleteUrl = '?' . $this->getQueryString($filters, $key, $value);

        if (Translations::attributeValues()->has($this->value)) {
            $this->name = Translations::attributeValues()->get($this->value)->get(app()->getLocale());
        } else {
            $this->name = $this->value;
        }
    }
}
