<div
    x-data="{
        showCreateDirectoryModal: false,
        showFileInfo: false,
        showDirectoryInfo: false,
        isLoading: false,
        selectable: {{ $selectable ? 'true' : 'false' }},
        init() {
            this.$watch('isLoading', () => {});
        },
        toggleDirectoryModal() { this.showCreateDirectoryModal = !this.showCreateDirectoryModal; },
    }"
    x-on:toggle-create-directory-modal="showCreateDirectoryModal = !showCreateDirectoryModal"
    x-on:directory-created="showCreateDirectoryModal = false"
    x-on:select-file.window="if (!selectable) { showFileInfo = true; }"
    x-on:open-directory-info.window="showDirectoryInfo = true"
    x-on:close-directory-info.window="showDirectoryInfo = false"
    x-on:keydown.escape.window="showFileInfo = false; showCreateDirectoryModal = false"
    x-on:file-deleted.window="showFileInfo = false"
    class="relative {{ $selectable ? 'min-h-[90vh] flex flex-col' : '' }}"
>
    <div class="sticky top-0 bg-white z-50 py-4 border-b border-gray-200 {{ $selectable ? 'px-6 -mt-6 mb-4' : '-mt-6 -mx-8 px-8 mb-4' }}">
        <livewire:daylight::media-directory-header :directory-id="$directoryId" :search="$search" :key="'header-'.$directoryId.'-'.$refreshKey" />
    </div>

    <div class="{{ $selectable ? 'px-6 pb-6 pt-2 flex-1' : '' }}">
        <x-daylight::media.create-directory-modal x-show="showCreateDirectoryModal" @close.window="showCreateDirectoryModal = false" />
        <livewire:daylight::media-uploader :directory-id="$directoryId" :key="'uploader-'.$directoryId" />
        
        @if($isUploading)
            <div class="mb-6 bg-blue-50 border border-blue-200 rounded-lg p-4">
                <div class="flex items-center gap-3">
                    <svg class="animate-spin h-5 w-5 text-blue-600" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                    <div class="flex-1">
                        <p class="text-sm font-medium text-blue-900">{{ __('daylight::media.uploading') }}</p>
                        <p class="text-xs text-blue-700">{{ __('daylight::media.uploading_count', ['count' => $uploadingCount]) }}</p>
                    </div>
                </div>
            </div>
        @endif
        
        <livewire:daylight::media-directory-list :directory-id="$directoryId" :selectable="$selectable" :key="'list-'.$directoryId.'-'.$refreshKey" />

        <livewire:daylight::media-file-grid 
            :directory-id="$directoryId" 
            :search="$search" 
            :selectable="$selectable" 
            :single-file="$singleFile"
            :selected-items="$selectedItems" 
            wire:key="grid-{{ $directoryId }}-{{ $refreshKey }}-{{ md5($search) }}" 
        />
    </div>

    @if($selectable)
        <div class="sticky bottom-0 bg-white border-t border-gray-300 py-4 px-6 flex items-center justify-between z-50 mt-auto">
            <p class="text-sm text-gray-500">{{ __('daylight::media.items_selected', ['count' => count($selectedItems)]) }}</p>
            <div class="flex items-center justify-end gap-4">
                <x-daylight::buttons.secondary wire:click="$dispatch('media-selector-close')">{{ __('daylight::general.cancel') }}</x-daylight::buttons.secondary>
                <x-daylight::buttons.primary wire:click="submitSelectedFiles">{{ __('daylight::general.select') }}</x-daylight::buttons.primary>
            </div>
        </div>
    @endif

    <x-daylight::media.loader x-show="isLoading" />

    <!-- File info slideover -->
    <div x-cloak class="fixed inset-0 z-50" :class="{ 'pointer-events-none': !showFileInfo, 'pointer-events-auto': showFileInfo }">
        <!-- backdrop -->
        <div
            class="absolute inset-0 bg-black/30"
            x-on:click="showFileInfo = false"
            x-show="showFileInfo"
            x-transition.opacity
        ></div>
        <!-- panel -->
        <div
            class="absolute inset-y-0 right-0 w-full max-w-xl bg-white shadow-xl border-l border-gray-200 flex flex-col"
            x-show="showFileInfo"
            x-transition:enter="transform transition ease-out duration-300"
            x-transition:enter-start="translate-x-full opacity-0"
            x-transition:enter-end="translate-x-0 opacity-100"
            x-transition:leave="transform transition ease-in duration-200"
            x-transition:leave-start="translate-x-0 opacity-100"
            x-transition:leave-end="translate-x-full opacity-0"
        >
            <div class="bg-sky-600 px-4 py-6 sm:px-6">
                <div class="flex items-start justify-between space-x-3">
                    <div class="space-y-1">
                        <h2 class="text-base font-semibold leading-6 text-white">{{ __('daylight::media.details') }}</h2>
                    </div>
                    <div class="flex h-7 items-center">
                        <button x-on:click.prevent="showFileInfo = false" type="button" class="relative text-white hover:text-opacity-75">
                            <span class="absolute -inset-2.5"></span>
                            <span class="sr-only">Close panel</span>
                            <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
            <div class="p-6 overflow-y-auto grow">
                <livewire:daylight::media-file-info />
            </div>
        </div>
    </div>

    <!-- Directory info slideover -->
    <div x-cloak class="fixed inset-0 z-50" :class="{ 'pointer-events-none': !showDirectoryInfo, 'pointer-events-auto': showDirectoryInfo }">
        <div class="absolute inset-0 bg-black/30" x-show="showDirectoryInfo" x-transition.opacity x-on:click="showDirectoryInfo = false"></div>
        <div class="absolute inset-y-0 right-0 w-full max-w-xl bg-white shadow-xl border-l border-gray-200 flex flex-col" x-show="showDirectoryInfo"
             x-transition:enter="transform transition ease-out duration-300"
             x-transition:enter-start="translate-x-full opacity-0"
             x-transition:enter-end="translate-x-0 opacity-100"
             x-transition:leave="transform transition ease-in duration-200"
             x-transition:leave-start="translate-x-0 opacity-100"
             x-transition:leave-end="translate-x-full opacity-0">
            <div class="flex h-full flex-col overflow-y-scroll bg-white shadow-xl">
                <div class="flex-1">
                    <div class="bg-sky-600 px-4 py-6 sm:px-6">
                        <div class="flex items-start justify-between space-x-3">
                            <div class="space-y-1">
                                <h2 class="text-base font-semibold leading-6 text-white">
                                    @if($directoryId)
                                        {{ \Daylight\Core\Modules\MediaLibrary\Models\Directory::find($directoryId)?->name ?? __('daylight::media.information') }}
                                    @else
                                        {{ __('daylight::media.information') }}
                                    @endif
                                </h2>
                                @if($directoryId)
                                    <p class="text-sm text-white text-opacity-75">{{ __('daylight::media.change_directory_message') }}</p>
                                @endif
                            </div>
                            <div class="flex h-7 items-center">
                                <button x-on:click.prevent="showDirectoryInfo = false" type="button" class="relative text-white hover:text-opacity-75">
                                    <span class="absolute -inset-2.5"></span>
                                    <span class="sr-only">Close panel</span>
                                    <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="space-y-6 py-6 sm:space-y-0 sm:divide-y sm:divide-gray-200 sm:py-0">
                        <div class="p-6">
                            <livewire:daylight::media-directory-info :directory-id="$directoryId" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>