<?php

namespace Daylight\Core\Models\Contracts;

use Illuminate\Support\Collection;

interface Relatable
{
    /**
     * Search for items matching the given query.
     */
    public static function searchForRelation(string $query, array $excludeIds = [], int $limit = 10): Collection;

    /**
     * Get items by their IDs for displaying selected items.
     */
    public static function getForRelation(array $ids): Collection;

    /**
     * Format an item for the relation API response.
     */
    public function formatForRelation(): array;
}
