<div>
    <x-daylight::input.group :label="__('daylight::general.category')" :error="$errors->first('category')" for="category_id">
        <x-daylight::input.select multiple searchable debug wire:model.change="activeCategories" :value="$activeCategories ? (is_array($activeCategories) ? $activeCategories : $activeCategories->toArray()) : []" placeholder="{{ __('Search categories...') }}">
            @foreach($categories as $category)
                @include('daylight::store.categories.partials.option', ['parent' => $category, 'level' => 0])
            @endforeach
        </x-daylight::input.select>
    </x-daylight::input.group>

    @foreach($this->generalAttributes() as $attribute)
        <x-daylight::input.group :label="$attribute->translations->first()?->name ?? $attribute->id" :error="$errors->first('attribute.' . $attribute->id)" for="attribute-{{ $attribute->id }}">
            <x-daylight::input.select multiple searchable wire:model.change="activeAttributes.{{ $attribute->id }}" :value="isset($activeAttributes[$attribute->id]) ? (is_array($activeAttributes[$attribute->id]) ? $activeAttributes[$attribute->id] : $activeAttributes[$attribute->id]->toArray()) : []" placeholder="{{ __('Search...') }}">
                @foreach($attribute->values as $value)
                    <option value="{{ $value->id }}" wire:key="{{ $value->id }}">
                        {{ $value->translations->first()->name }}
                    </option>
                @endforeach
            </x-daylight::input.select>
        </x-daylight::input.group>
    @endforeach

    @foreach($this->filteredAttributes() as $attribute)
        <x-daylight::input.group :label="$attribute->translations->first()?->name ?? $attribute->id" :error="$errors->first('attribute.' . $attribute->id)" for="attribute-{{ $attribute->id }}">
            <x-daylight::input.select multiple searchable wire:model.change="activeAttributes.{{ $attribute->id }}" :value="isset($activeAttributes[$attribute->id]) ? (is_array($activeAttributes[$attribute->id]) ? $activeAttributes[$attribute->id] : $activeAttributes[$attribute->id]->toArray()) : []" placeholder="{{ __('Search...') }}">
                @foreach($attribute->values as $value)
                    <option value="{{ $value->id }}">
                        {{ $value->translations->first()?->name ?? $value->id }}
                    </option>
                @endforeach
            </x-daylight::input.select>
        </x-daylight::input.group>
    @endforeach

    <div class="hidden">
        @foreach($activeCategories as $category)
            <input type="text" name="categories[]" value="{{ $category }}">
        @endforeach

        @foreach($activeAttributes as $attributeId => $values)
            @foreach($values as $value)
                <input type="text" name="attributes[{{ $attributeId }}][]" value="{{ $value }}">
            @endforeach
        @endforeach
    </div>
</div>
