<?php

namespace Daylight\Core\Http\Requests\Store\CustomerGroups;

use Illuminate\Foundation\Http\FormRequest;

class StoreCustomerGroupRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->check() && auth()->user()->can('create:customer-groups');
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:255'],
            'default' => ['required', 'integer', 'between:0,1'],
        ];
    }
}
