<?php

namespace Daylight\Core\Models;

use Daylight\Core\Modules\Multilingualism\Contracts\HasTranslations;
use Daylight\Core\Modules\Multilingualism\Models\Concerns\InteractsWithTranslations;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Option extends Model implements HasTranslations
{
    use InteractsWithTranslations;

    protected $guarded = [];

    public function translatedFields(): array
    {
        return ['name'];
    }

    public function values(): HasMany
    {
        return $this->hasMany(daylightModel('option_value'));
    }

    public function translations(): HasMany
    {
        return $this->hasMany(daylightModel('option_translation'));
    }

    public function defaultTranslation(): HasOne
    {
        return $this
            ->hasOne(daylightModel('option_translation'))
            ->where('locale', config('multilingualism.default_locale'));
    }
}
