@extends('daylight::layouts.app')

@section('title', __('daylight::content.create_new_menu'))

@section('content')
    <x-daylight::page-header :title="__('daylight::content.create_new_menu')"/>
    <x-daylight::session-messages />

    <form method="post" action="{{ route('daylight.content.menus.store') }}">
        @csrf

        <input type="hidden" name="locale" value="{{ request()->get('locale', app()->getLocale()) }}">

        <x-daylight::input.group
            :label="__('daylight::general.name')"
            :error="$errors->first('name')"
            :helpText="__('daylight::content.fields.help_name_general')"
            for="name"
        >
            <x-daylight::input.text
                name="name"
                id="name"
                value="{{ old('name') }}"
            />
        </x-daylight::input.group>

        <p class="text-sm my-4 text-gray-500">{{ __('daylight::content.messages.items_after_create') }}</p>

        <div class="mt-6 flex items-center justify-end gap-x-3">
            <x-daylight::buttons.secondary href="{{ route('daylight.content.menus.index') }}" element="a">
                {{ __('daylight::general.cancel') }}
            </x-daylight::buttons.secondary>

            <x-daylight::buttons.primary type="submit">
                {{ __('daylight::general.save') }}
            </x-daylight::buttons.primary>
        </div>
    </form>
@endsection
