<div x-data="{ confirmOpen: false }">
    @if($directory)
        <form wire:submit.prevent="update" class="flex h-full flex-col">
            <x-daylight::input.group
                :label="__('daylight::general.name')"
                :error="$errors->first('name')"
                for="directory-name"
            >
                <x-daylight::input.text
                    name="name"
                    id="directory-name"
                    wire:model.defer="name"
                />
            </x-daylight::input.group>

            <div class="flex flex-shrink-0 justify-between mt-6">
                <x-daylight::buttons.danger type="button" x-on:click.prevent="confirmOpen = true">
                    {{ __('daylight::general.delete') }}
                </x-daylight::buttons.danger>

                <x-daylight::buttons.primary type="submit">
                    {{ __('daylight::general.save') }}
                </x-daylight::buttons.primary>
            </div>
        </form>

        <!-- Confirmation modal -->
        <div class="fixed inset-0 z-[100] flex items-center justify-center" x-cloak x-show="confirmOpen">
            <div class="absolute inset-0 bg-black/30" x-on:click="confirmOpen = false"></div>
            <div class="bg-white rounded-lg shadow-lg w-full max-w-md relative z-10 p-6">
                <h3 class="text-lg font-medium mb-4">{{ __('daylight::general.confirm_deletion') }}</h3>
                <p class="text-sm text-gray-600">{{ __('daylight::media.confirm_delete_directory', ['name' => $directory->name]) }}</p>
                <div class="mt-6 flex items-center justify-end gap-3">
                    <x-daylight::buttons.secondary x-on:click.prevent="confirmOpen = false">
                        {{ __('daylight::general.cancel') }}
                    </x-daylight::buttons.secondary>

                    <x-daylight::buttons.danger wire:click="delete" x-on:click.prevent="confirmOpen = false">
                        {{ __('daylight::general.delete') }}
                    </x-daylight::buttons.danger>
                </div>
            </div>
        </div>
    @else
        <div class="p-6">
            <p class="text-sm text-gray-500">{{ __('daylight::general.loading') }}</p>
        </div>
    @endif
</div>


