<div x-data="{
    showDropdown: @entangle('showDropdown'),
    items: @entangle('selected').live,
    handleSort(item, position) {
        // Get all IDs in current order
        const order = Array.from($refs.sortableContainer.children).map(el => {
            return el.getAttribute('data-item-id');
        }).filter(Boolean);

        // Sync to Livewire (which will update items via entangle)
        $wire.reorderItems(order);
    },
    removeItem(index) {
        // Only call Livewire, entangle will update items automatically
        $wire.removeItem(index);
    }
}" class="relative">
    <!-- Selected Items -->
    <template x-if="items.length > 0">
        <div class="mb-2 flex flex-wrap gap-2" x-ref="sortableContainer" x-sort="handleSort">
            <template x-for="(item, index) in items" :key="item.id">
                <div
                    x-sort:item
                    :data-item-id="item.id"
                    class="inline-flex items-center gap-2 px-3 py-1.5 bg-sky-100 text-sky-800 rounded-lg text-sm"
                >
                    <span x-sort:handle class="cursor-move">
                        <svg class="w-3.5 h-3.5 text-sky-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 8h16M4 16h16" />
                        </svg>
                    </span>
                    <span x-text="item.name || 'Unknown'"></span>
                    <span x-show="item.id" class="text-sky-600 text-xs" x-text="`(ID: ${item.id})`"></span>
                    <button
                        type="button"
                        @click="removeItem(index)"
                        class="hover:text-sky-900"
                        style="width: 15px;"
                    >
                        <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                        </svg>
                    </button>
                </div>
            </template>
        </div>
    </template>

    <!-- Hidden textarea for form submission (using JSON like MediaSelector) -->
    <textarea name="{{ $name }}" class="hidden">{{ json_encode($selected) }}</textarea>

    <!-- Search Input -->
    <div class="relative">
        <input
            type="text"
            wire:model.live.debounce.300ms="searchQuery"
            x-on:focus="showDropdown = true"
            x-on:keydown.escape="showDropdown = false"
            placeholder="{{ $placeholder }}"
            class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 focus:ring-2 focus:ring-inset focus:ring-sky-600 sm:text-sm sm:leading-6"
        />

        <!-- Search Results Dropdown -->
        <div
            x-show="showDropdown && $wire.searchResults.length > 0"
            x-on:click.away="showDropdown = false"
            x-transition:enter="transition ease-out duration-100"
            x-transition:enter-start="transform opacity-0 scale-95"
            x-transition:enter-end="transform opacity-100 scale-100"
            x-transition:leave="transition ease-in duration-75"
            x-transition:leave-start="transform opacity-100 scale-100"
            x-transition:leave-end="transform opacity-0 scale-95"
            class="absolute z-10 mt-1 w-full bg-white shadow-lg rounded-md border border-gray-200 max-h-60 overflow-auto"
            style="display: none;"
        >
            @foreach($searchResults as $result)
                <button
                    type="button"
                    wire:click="selectItem({{ json_encode($result) }})"
                    class="w-full text-left px-4 py-2 hover:bg-gray-50 flex items-center justify-between"
                >
                    <div>
                        <div class="text-sm font-medium text-gray-900">{{ $result['name'] }}</div>
                        @if(isset($result['id']))
                            <div class="text-xs text-gray-500">ID: {{ $result['id'] }}</div>
                        @endif
                        @if(isset($result['sku']))
                            <div class="text-xs text-gray-500">SKU: {{ $result['sku'] }}</div>
                        @endif
                        @if(isset($result['brand']))
                            <div class="text-xs text-gray-500">{{ $result['brand'] }}</div>
                        @endif
                    </div>
                </button>
            @endforeach
        </div>

        <!-- No Results Message -->
        @if($showDropdown && strlen($searchQuery) >= 2 && $searchResults->isEmpty())
            <div class="absolute z-10 mt-1 w-full bg-white shadow-lg rounded-md border border-gray-200 px-4 py-3">
                <p class="text-sm text-gray-500">{{ __('daylight::general.no_results_found') }}</p>
            </div>
        @endif
    </div>

    <!-- Hint Text -->
    <template x-if="items.length === 0 && '{{ $searchQuery }}'.length < 2">
        <p class="mt-1 text-xs text-gray-500">{{ __('daylight::general.type_to_search') }}</p>
    </template>
</div>

