<?php

namespace Daylight\Core\Http\Middleware;

use Closure;
use Daylight\Core\Modules\PhoneValidation\Contracts\MustVerifyMobile;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureMobileVerified
{
    public function handle(Request $request, Closure $next): Response
    {
        if (config('app.two_factor_authentication.method') !== 'sms') {
            return $next($request);
        }

        if (! auth()->check()) {
            return $next($request);
        }

        if (! $request->user() || ($request->user() instanceof MustVerifyMobile && ! $request->user()->hasVerifiedMobile())) {
            return redirect()->translatedRoute('mobile-verification');
        }

        return $next($request);
    }
}
