<?php

namespace Daylight\Core\Modules\Admin\Entities;

class Shortcut
{
    public string $key;

    public string $color;

    public string $icon;

    public string $label;

    public string $description;

    protected bool $translateLabel = false;

    protected bool $translateDescription = false;

    public string $route;

    public ?string $permission = null;

    public int $order = 0;

    public function getKey(): string
    {
        return $this->key;
    }

    public function setKey(string $key): self
    {
        $this->key = $key;

        return $this;
    }

    public function getColor(): string
    {
        return $this->color;
    }

    public function setColor(string $color): self
    {
        $this->color = $color;

        return $this;
    }

    public function getIcon(): string
    {
        return $this->icon;
    }

    public function setIcon(string $icon): self
    {
        $this->icon = $icon;

        return $this;
    }

    public function setLabel(string $label): self
    {
        $this->label = $label;
        $this->translateLabel = str_starts_with($label, 'daylight::');

        return $this;
    }

    public function getLabel(): string
    {
        if ($this->translateLabel && function_exists('__')) {
            return __($this->label);
        }

        return $this->label;
    }

    public function getDescription(): string
    {
        if ($this->translateDescription && function_exists('__')) {
            return __($this->description);
        }

        return $this->description;
    }

    public function setDescription(string $description): self
    {
        $this->description = $description;
        $this->translateDescription = str_starts_with($description, 'daylight::');

        return $this;
    }

    public function getRoute(): string
    {
        return $this->route;
    }

    public function setRoute(string $route): self
    {
        $this->route = $route;

        return $this;
    }

    public function getPermission(): ?string
    {
        return $this->permission;
    }

    public function setPermission(?string $permission): self
    {
        $this->permission = $permission;

        return $this;
    }

    public function getOrder(): int
    {
        return $this->order;
    }

    public function setOrder(int $order): self
    {
        $this->order = $order;

        return $this;
    }

    public static function create(): self
    {
        return new self;
    }
}
