@props(['address', 'type' => 'billing'])

<p class="block text-sm leading-6 text-gray-700 font-medium">{{ $address->name ?? '' }}</p>
<p class="block text-sm leading-6 text-gray-700">{{ $address->address_line_1 }}</p>
@if($address->address_line_2)
    <p class="block text-sm leading-6 text-gray-700">{{ $address->address_line_2 }}</p>
@endif
<p class="block text-sm leading-6 text-gray-700">{{ $address->postal_code }} {{ $address->city }}</p>
<p class="block text-sm leading-6 text-gray-700">{{ $address->country->name }}</p>

@if($address->vat_number && $type === 'billing')
    <div class="mt-4 text-sm leading-6 text-gray-700">
        <div class="flex items-center">
            <p>{{ $address->vat_number }}</p>

            @if($address->vat_number_verified_at && $address->country_id !== \Daylight\Core\Services\Countries::defaultCountry()->id)
                <svg class="ml-1 w-4 h-4 text-green-600" data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75 11.25 15 15 9.75M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z"></path>
                </svg>
            @endif
        </div>

        @if($address->vat_number_verified_at && $address->country_id !== \Daylight\Core\Services\Countries::defaultCountry()->id)
            <div class="text-xs text-gray-400">
                <p>{{ __('daylight::general.vat_reverse_charge') }}</p>
            </div>
        @endif
    </div>
@endif
